﻿using System;
using System.Linq;
using HIPS.HpiiSchemas;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class SearchResultViewModelExtensions
    {
        public static SearchResultViewModel LoadFromResponse(this SearchResultViewModel viewModel, HpiiQueryResponse response)
        {
            viewModel.Hpii = response.HpiiNumber;
            viewModel.RegistrationId = response.RegistrationId;
            viewModel.Hpio = response.HpioNumber;
            viewModel.FamilyName = response.FamilyName;
            viewModel.GivenNames = String.Join(" ", response.GivenName ?? Enumerable.Empty<string>());
            viewModel.SexCode = response.Sex.HasValue ? response.Sex.Value.ToString() : String.Empty;
            viewModel.DateOfBirth = response.DateofBirth;
            viewModel.StateCode = response.State.HasValue ? response.State.ToString() : String.Empty;
            viewModel.Postcode = response.PostCode;
            viewModel.HpiiStatus = response.HpiiStatus.ToString();

            // Australian Address
            if (response.AustralianAddress != null)
            {
                viewModel.AustralianAddress.LoadFromAustralianAddress(response.AustralianAddress);
            }

            // International Address
            if (response.InternationalAddress != null)
            {
                viewModel.InternationalAddress.LoadFromInternationalAddress(response.InternationalAddress);
            }

            // Errors/Warnings/Infos
            if (response.ServiceMessagesType != null)
            {
                viewModel.ResponseMessages.Errors = response.ServiceMessagesType.serviceMessage
                                                            .Where(s => s.severity == SeverityType.Error || s.severity == SeverityType.Fatal)
                                                            .Select(s => s.reason).ToList();

                viewModel.ResponseMessages.Warnings = response.ServiceMessagesType.serviceMessage
                                                              .Where(s => s.severity == SeverityType.Warning)
                                                              .Select(s => s.reason).ToList();

                viewModel.ResponseMessages.Infos = response.ServiceMessagesType.serviceMessage
                                                           .Where(s => s.severity == SeverityType.Informational)
                                                           .Select(s => s.reason).ToList();
            }

            // TODO: Do we want other behaviour for not-okay HipsResponse Status? Is ToString() Okay? Is this redundant for validation errors?
            // TODO: HIPS Currently always returning Error status. Re-add this once determine desired behaviour.
            //if (response.HipsResponse.Status != HipsResponseIndicator.OK)
            //{
            //    viewModel.ResponseMessages.Errors.Add(String.Format("An error was encountered. ({0})", response.HipsResponse.ToString()));
            //}

            // 'Not Found' Warnings
            if (response.HipsResponse.ResponseCode == "WSE0035")
            {
                viewModel.ResponseMessages.Warnings.Add("No HPI-I was found.");
            }

            return viewModel;
        }
    }
}